********************************************
*         Plotting rate functions
*        Josef Brderl, March 2011
********************************************

* Proportionality assumption
* Generalized Log-Logistic Model (alpha = varies, p=2, lambda = 0.2)
twoway                                                                               /// 
 (function y=0.1*(2*(.2*x))/(1+(.2*x)^2),   range(0 20) clwidth(*2) clcolor(blue))   ///
 (function y=0.2*(2*(.2*x))/(1+(.2*x)^2),   range(0 20) clwidth(*2) clcolor(red)),   ///
     title("") legend(off) xline(5 10 15)                                            ///
    ylabel(0(.025).2, angle(0) format(%4.3f) grid) ytitle("rate", size(large))       ///
    xlabel(0(5)20) xtitle("t", size(large) margin(0 0 0 2))                    

	
* Generalized Log-Logistic Model (alpha = 0.1, lambda = 0.2)
twoway                                                                                                         /// 
 (function y=0.1*(.5*(.2*x)^-.5)/(1+(.2*x)^.5),   range(0.11 20) clwidth(*2) clcolor(blue) yvarlab("p=0.5"))   ///
 (function y=0.1/(1+(.2*x)),                      range(0 20)    clwidth(*2) clcolor(red)   yvarlab("p=1.0"))  ///
 (function y=0.1*(2.5*(.2*x)^1.5)/(1+(.2*x)^2.5), range(0 20)    clwidth(*2) clcolor(green) yvarlab("p=2.5"))  ///
 (function y=0.1*(4*(.2*x)^3)/(1+(.2*x)^4),       range(0 20)    clwidth(*2) clcolor(cyan)  yvarlab("p=4.0")), ///
    title("Gen-loglog rate: alpha=0.1, lambda=0.2, p varying")                                                 ///
    ylabel(0(.05).3, angle(0) format(%3.2f) grid) ytitle("rate", size(large))                                  ///
    xlabel(0(5)20) xtitle("t", size(large) margin(0 0 0 2)) legend(pos(1) ring(0))                    
	

* Log-Logistic Model (p = 2.5)
twoway                                                                                                               /// 
 (function y=(.10*2.5*(.10*x)^1.5)/(1+(.10*x)^2.5), range(0 20)   clwidth(*2) clcolor(blue) yvarlab("lambda=0.10"))  ///
 (function y=(.15*2.5*(.15*x)^1.5)/(1+(.15*x)^2.5), range(0 20)   clwidth(*2) clcolor(green) yvarlab("lambda=0.15")) ///
 (function y=(.20*2.5*(.20*x)^1.5)/(1+(.20*x)^2.5), range(0 20)   clwidth(*2) clcolor(red) yvarlab("lambda=0.20")),  ///
    xsize(4.5) title("Log-logistic rate: p=2.5, lambda varying")                                                     ///
    ylabel(0(.05).3, angle(0) format(%3.2f) grid) ytitle("rate", size(large))                                        ///
    xlabel(0(5)20) xtitle("t", size(large) margin(0 0 0 2)) legend(pos(1) ring(0) rows(3) order(3 2 1))                    

	
* Weibull Model (alpha = 0.1)
twoway                                                                                        /// 
 (function y=0.1*0.8*x^(-0.2), range(0.0013 20) clwidth(*2) clcolor(blue) yvarlab("p=0.8"))   ///
 (function y=0.1,              range(0 20)      clwidth(*2) clcolor(red)   yvarlab("p=1.0"))  ///
 (function y=0.1*1.2*x^(0.2),  range(0 20)      clwidth(*2) clcolor(green) yvarlab("p=1.2"))  ///
 (function y=0.1*2*x,          range(0 1.5)     clwidth(*2) clcolor(cyan)  yvarlab("p=2.0")), ///
    xsize (4.5) title("Weibull rate: alpha=0.1, p varying")                                   ///
    ylabel(0(.05).3, angle(0) format(%3.2f) grid) ytitle("rate", size(large))                 ///
    xlabel(0(5)20) xtitle("t", size(large) margin(0 0 0 2))                     


* Discrete-time Weibull (exp(-*x)=9)
twoway                                                                    /// 
 (function y=(1+9*(x+1)^.5)^-1,  range(0 20) n(21) c(J) clwidth(*2) clcolor(blue) yvarlab("p=0.5"))   ///
 (function y=(1+9)^-1,           range(0 20) n(21) c(J) clwidth(*2) clcolor(red)  yvarlab("p=1.0"))  ///
 (function y=(1+9*(x+1)^-.4)^-1, range(0 20) n(21) c(J) clwidth(*2) clcolor(green) yvarlab("p=1.4")),  ///
    title("Discrete-Weibull (logistic model): exp(-*x)=9, p varying")                            ///
    ylabel(0(.05).3, angle(0) format(%3.2f) grid) ytitle("discrete-time rate")           ///
    xlabel(0(5)20) xtitle("t")  legend(rows(1))                  

	
* Exponential mixture (Mover-Stayer model)
twoway                                                                                        /// 
 (function y=0,                   range(0 50) clwidth(*2) clcolor(blue)  yvarlab("stayer"))   ///
 (function y=0.1,                 range(0 50) clwidth(*2) clcolor(red)   yvarlab("mover"))    ///
 (function y=0.1/(1+exp(0.1*x)),  range(0 50) clwidth(*2) clcolor(green) yvarlab("mixture")), ///
    xsize (4.5) title("Mover-Stayer Model, p1=p2=0.5")                                        ///
    ylabel(0(.025).1, angle(0) format(%4.3f) grid) ytitle("rate", size(large))                ///
    xlabel(0(10)50) xtitle("t", size(large) margin(0 0 0 2))                                  ///
	legend(pos(3) ring(0) rows(3) order(2 1 3))                    

	
* Exponential/Weibull mixture (Mover-Stayer model)
twoway                                                                                        /// 
 (function y=0,                                               range(0 50) clwidth(*2) clcolor(blue)  yvarlab("stayer"))   ///
 (function y= 1.2*(0.06^1.2)*(x^0.2),                         range(0 50) clwidth(*2) clcolor(red)   yvarlab("mover"))    ///
 (function y=(1.2*(0.06^1.2)*(x^0.2))/(1+exp((0.06*x)^1.2)),  range(0 50) clwidth(*2) clcolor(green) yvarlab("mixture")), ///
    xsize (4.5) title("Mover (Weibull)-Stayer Model, p1=p2=0.5")                              ///
    ylabel(0(.025).1, angle(0) format(%4.3f) grid) ytitle("rate", size(large))                ///
    xlabel(0(10)50) xtitle("t", size(large) margin(0 0 0 2))                                  ///
	legend(pos(3) ring(0) rows(3) order(2 1 3))                  
